/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.sim.toolkit.designer.properties.resources.VWSIMResource;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.table.VWRouteListCellRenderer;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class VWRouteWeightTableModel
extends AbstractTableModel {
    private static final int NUM_COLUMNS = 2;
    public static final int COL_NAME = 0;
    public static final int COL_WEIGHT = 1;
    private Vector m_rowData = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWMapNode m_mapNode = null;

    public VWRouteWeightTableModel(VWAuthPropertyData propertyData) {
        this.m_authPropertyData = propertyData;
        this.m_rowData = new Vector();
    }

    public VWRouteDefinition getItemAt(int nRow) {
        if (this.m_rowData != null && nRow >= 0 && nRow < this.m_rowData.size()) {
            return (VWRouteDefinition)this.m_rowData.elementAt(nRow);
        }
        return null;
    }

    public void reinitialize(VWMapNode mapNode) {
        block11: {
            try {
                VWRouteDefinition[] routeDefs;
                this.m_rowData.removeAllElements();
                this.m_mapNode = mapNode;
                if (mapNode == null || (routeDefs = mapNode.getNextRoutes()) == null || routeDefs.length <= 0) break block11;
                switch (mapNode.getSplitType()) {
                    case 2: {
                        int nWeight = 100 / routeDefs.length;
                        int nRemainder = 100 % routeDefs.length;
                        for (int nIndex = 0; nIndex < routeDefs.length; ++nIndex) {
                            Object value = this.getRouteWeight(routeDefs[nIndex]);
                            if (value == null) {
                                if (nIndex == routeDefs.length - 1) {
                                    this.setRouteWeight(routeDefs[nIndex], new Integer(nWeight + nRemainder));
                                } else {
                                    this.setRouteWeight(routeDefs[nIndex], new Integer(nWeight));
                                }
                            }
                            this.m_rowData.addElement(routeDefs[nIndex]);
                        }
                        break;
                    }
                    case 1: {
                        for (int nIndex = 0; nIndex < routeDefs.length; ++nIndex) {
                            this.setRouteWeight(routeDefs[nIndex], new Integer(100));
                            this.m_rowData.addElement(routeDefs[nIndex]);
                        }
                        break;
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        this.fireTableDataChanged();
    }

    public int getTotalWeight() {
        int total = 0;
        if (this.getRowCount() > 0) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                VWRouteDefinition routeDef = this.getItemAt(i);
                Object value = this.getRouteWeight(routeDef);
                if (value == null || !(value instanceof Integer)) continue;
                total += ((Integer)value).intValue();
            }
        }
        return total;
    }

    public void moveRouteUp(int nRowIndex) {
        try {
            if (nRowIndex <= 0 || nRowIndex >= this.getRowCount()) {
                return;
            }
            VWRouteDefinition routeDef = this.getItemAt(nRowIndex);
            if (routeDef != null) {
                this.m_rowData.removeElementAt(nRowIndex);
                this.m_rowData.insertElementAt(routeDef, nRowIndex - 1);
                this.updateRouteOrder();
                this.fireTableRowsInserted(nRowIndex - 1, nRowIndex);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void moveRouteDown(int nRowIndex) {
        try {
            if (nRowIndex < 0 || nRowIndex >= this.getRowCount() - 1) {
                return;
            }
            VWRouteDefinition routeDef = this.getItemAt(nRowIndex);
            if (routeDef != null) {
                this.m_rowData.removeElementAt(nRowIndex);
                this.m_rowData.insertElementAt(routeDef, nRowIndex + 1);
                this.updateRouteOrder();
                this.fireTableRowsInserted(nRowIndex, nRowIndex + 2);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Class getColumnClass(int nColumn) {
        switch (nColumn) {
            case 0: 
            case 1: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int nColumn) {
        switch (nColumn) {
            case 0: {
                return VWSIMResource.s_routeName;
            }
            case 1: {
                return VWSIMResource.s_weightPercentage;
            }
        }
        return null;
    }

    public int getRowCount() {
        return this.m_rowData.size();
    }

    public Object getValueAt(int nRow, int nColumn) {
        try {
            VWRouteDefinition routeDef = this.getItemAt(nRow);
            switch (nColumn) {
                case 0: {
                    return VWRouteListCellRenderer.toString(routeDef);
                }
                case 1: {
                    return this.getRouteWeight(routeDef);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRow, int nColumn) {
        switch (nColumn) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public void setValueAt(Object value, int nRow, int nColumn) {
        switch (nColumn) {
            case 1: {
                this.onUpdateWeight(value, nRow);
            }
        }
    }

    private void onUpdateWeight(Object aValue, int nRow) {
        block6: {
            try {
                VWRouteDefinition routeDef;
                if (aValue == null) break block6;
                Integer weightValue = null;
                try {
                    weightValue = new Integer((String)aValue);
                }
                catch (Exception ex) {
                    VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), VWSIMResource.s_invalidRouteWeight.toString((String)aValue), 1);
                    return;
                }
                if (weightValue == null || (routeDef = this.getItemAt(nRow)) == null) break block6;
                Object objWeight = this.getRouteWeight(routeDef);
                try {
                    this.setRouteWeight(routeDef, weightValue);
                }
                catch (Exception ex) {
                    VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
                    this.setRouteWeight(routeDef, objWeight);
                }
                this.fireTableCellUpdated(nRow, 1);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    private void updateRouteOrder() {
        try {
            int nRowCount = this.getRowCount();
            if (this.m_mapNode == null || nRowCount == 0) {
                return;
            }
            int[] routeIds = new int[nRowCount];
            for (int nRow = 0; nRow < nRowCount; ++nRow) {
                VWRouteDefinition routeDef = this.getItemAt(nRow);
                if (routeDef == null) continue;
                routeIds[nRow] = routeDef.getRouteId();
            }
            this.m_mapNode.reorderRoutes(routeIds);
            this.m_authPropertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void setRouteWeight(VWRouteDefinition routeDef, Object value) throws Exception {
        if (routeDef == null) {
            return;
        }
        VWAttributeInfo attributeInfo = routeDef.getAttributeInfo();
        if (attributeInfo == null) {
            attributeInfo = new VWAttributeInfo();
        }
        attributeInfo.setFieldValue("UI_RouteWeight", value);
        routeDef.setAttributeInfo(attributeInfo);
        this.m_authPropertyData.setDirty();
    }

    private Object getRouteWeight(VWRouteDefinition routeDef) {
        try {
            if (routeDef == null) {
                return null;
            }
            VWAttributeInfo attributeInfo = routeDef.getAttributeInfo();
            if (attributeInfo != null) {
                return attributeInfo.getFieldValue("UI_RouteWeight");
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }
}

